IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_ETL_Group_Icon_Association_Delete]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ufn_ETL_Group_Icon_Association_Delete]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[ufn_ETL_Group_Icon_Association_Delete](@START_DATE DATETIME, @END_DATE DATETIME)
RETURNS TABLE 
AS
RETURN
(
	SELECT  BIA.ID as [SOURCE_ID]
	FROM dbo.BMS_ICON_ASSOCIATION as BIA 
	WHERE BIA.[_isDeleted] = 1 AND BIA.[_ssis_timestamp] > @START_DATE
			AND BIA.[_ssis_timestamp] < @END_DATE
)
GO


